#pragma once

#include "reader_pool.h"

namespace NPassport::NUtils {
    class ILogger;
}

namespace NPassport::NLb {
    class TBaseParser {
    public:
        TBaseParser(TString parserName)
            : ParserName_(parserName)
        {
        }

        ui64 GetErrorCount() const {
            return Errors_;
        }

        size_t GetRowsIn() const {
            return TotalRowsIn_;
        }

        virtual bool ParseRow(TStringBuf line) = 0;
        virtual void Reserve(size_t size) = 0;
        virtual void LogBadLine(TStringBuf line) = 0;

    protected:
        void ReserveForTopic(const NLb::TTopicData& data);

        template <typename LogType>
        void ParseRows(const TDataSet<LogType>& data) {
            for (const TDataWithType<LogType>& d : data) {
                ParseRows(d.Data);
            }
        }

        void ParseRows(const NLb::TData& data);

        void ParseRows(const NLb::TTopicData& data);

    private:
        TStringBuf SkipZeroPrefix(TStringBuf buf);

    private:
        ui64 Errors_ = 0;
        size_t TotalRowsIn_ = 0;
        TString ParserName_;
    };

    class TParserWithBadLineLog: public NLb::TBaseParser {
    public:
        template <class LogTypeTraits>
        TParserWithBadLineLog(LogTypeTraits,
                              typename LogTypeTraits::TType logType,
                              NUtils::ILogger* logger)
            : TBaseParser(LogTypeTraits::ToString(logType))
            , Logger_(logger)
        {
        }

    private:
        void LogBadLine(TStringBuf line) override;

    private:
        NUtils::ILogger* Logger_;
    };
}
