#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLb;

Y_UNIT_TEST_SUITE(Parser) {
    class TTestParser: public TBaseParser {
    public:
        TTestParser()
            : TBaseParser("")
        {
        }

        using TBaseParser::ParseRows;

        void Reserve(size_t) override {
        }

        void LogBadLine(TStringBuf) override {
            ++Errors;
        }

        ui64 Errors = 0;
    };

    template <typename T>
    static void Test(TString line, ui64 expectedErrors, ui64 expectedLines) {
        T parser;
        TData data;

        TTopicData td;
        td.Data.push_back(NLb::TChunk{
            .Data = std::move(line),
        });
        data.Messages.push_back(std::move(td));

        parser.ParseRows(data);
        UNIT_ASSERT_VALUES_EQUAL(expectedErrors, parser.Errors);
        UNIT_ASSERT_VALUES_EQUAL(expectedLines, parser.Lines);
    }

    Y_UNIT_TEST(badLineWithoutEndl) {
        struct TPars: public TTestParser {
            bool ParseRow(TStringBuf) override {
                ++Lines;
                return true;
            }

            ui64 Lines = 0;
        };

        Test<TPars>("some mega line", 1, 0);
        Test<TPars>("some mega line\n", 0, 1);
    }

    Y_UNIT_TEST(badLineFailedToParse) {
        struct TPars: public TTestParser {
            bool ParseRow(TStringBuf line) override {
                if (line == "foo") {
                    ythrow yexception();
                }

                ++Lines;
                return true;
            }

            ui64 Lines = 0;
        };

        Test<TPars>("foo\n", 1, 0);
        Test<TPars>("bar\n", 0, 1);
    }

    Y_UNIT_TEST(lineWithLeadingX00) {
        struct TPars: public TTestParser {
            bool ParseRow(TStringBuf line) override {
                if (line[0] == '\x00') {
                    ythrow yexception();
                }

                ++Lines;
                return true;
            }

            ui64 Lines = 0;
        };

        TString someMegaLine = "some mega line\n";
        Test<TPars>(someMegaLine, 0, 1);
        someMegaLine[0] = someMegaLine[1] = '\x00';
        Test<TPars>(someMegaLine, 0, 1);
    }
}
