#pragma once

#include <passport/infra/libs/cpp/logbroker/reader/reader.h>

#include <passport/infra/libs/cpp/unistat/time_stat.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>

#include <util/datetime/base.h>

#include <deque>

namespace NKikimrClient {
    class TPersQueueReadResponse;
}

namespace NPassport::NLb {
    struct TReaderSettings;

    class TFetcher {
    public:
        TFetcher(NPersQueue::TPQLib& pq,
                 const NPersQueue::TConsumerSettings& pqSettings,
                 const TReaderSettings& settings,
                 TIntrusivePtr<NPersQueue::ILogger>& logger,
                 NUnistat::TTimeStat& timestat);
        ~TFetcher();

    public:
        void WaitForAWhile();
        void ForceCommit();
        ui64 Process(TReader::TLoopFunc func);

        struct TMessage {
            NThreading::TFuture<void> Future;
            ui64 DataSize = 0;
            ui64 Cookie = 0;
            TInstant StartTime = TInstant::Now();
        };

        struct TDataWithInfo {
            TData Data;
            ui64 DataSize = 0;
            ui64 Messages = 0;
            ui64 Cookie = 0;
        };

    private:
        ui64 ProcessReads(TReader::TLoopFunc func);
        std::optional<TDataWithInfo> TryGetNextData();
        void Commit();

        void SendRequestForNextMsg();
        static TDataWithInfo TranslateResp(const NPersQueue::TReadResponse& resp,
                                           const TString& traceid);

        void Cleanup();

    private:
        TAutoEvent Ev_;
        NThreading::TFuture<NPersQueue::TConsumerMessage> Read_;
        std::optional<TDataWithInfo> NextData_;
        std::deque<TMessage> Messages_;
        TVector<ui64> ToCommit_; // allocated memory
        const TReaderSettings* Settings_;
        TInstant LastCommitTime_;
        THolder<NPersQueue::IConsumer> Consumer_;

        NUnistat::TTimeStat& Timestat_;
    };
}
