#pragma once

#include <passport/infra/libs/cpp/logbroker/reader/reader.h>

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/exponential_backoff.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>

#include <atomic>

namespace NPersQueue {
    struct TConsumerSettings;
    class ILogger;
    class TPQLib;
}

namespace NPassport::NLb {
    class TFetcher;

    class TLogger: public NPersQueue::ILogger {
    public:
        TLogger(int logLevel)
            : LogLevel(logLevel)
        {
        }

        void Log(const TString& msg, const TString& sourceId, const TString& sessionId, int level) override {
            if (level > LogLevel) {
                return;
            }

            void (*func)(const char*, ...);

            switch (level) {
                case 0:
                case 1:
                case 2:
                case 3:
                    func = TLog::Error;
                    break;
                case 4:
                    func = TLog::Warning;
                    break;
                case 5:
                case 6:
                    func = TLog::Info;
                    break;
                case 7:
                    func = TLog::Debug;
                    break;
                default:
                    TLog::Error("Unexpected log level: %d", level);
                    func = TLog::Error;
                    break;
            }

            (*func)("PQ src=%s;sess=%s: %s", sourceId.c_str(), sessionId.c_str(), msg.c_str());
        }

        bool IsEnabled(int level) const override {
            return level <= LogLevel;
        }

        const int LogLevel;
    };

    class TReader::TImpl {
    public:
        TImpl(const TReaderSettings& settings);

        void StartLoop(TReader::TLoopFunc func);
        void StopLoop();
        void AddUnistat(NUnistat::TBuilder& builder) const;

        bool IsOk() const;
        const TString& GetServer() const;

    private:
        bool IsRunning() const;
        std::unique_ptr<TFetcher> MakeNewFetcher();
        NPersQueue::TConsumerSettings TranslateSettings(const TReaderSettings& sets);

    private:
        const TReaderSettings Settings_;
        NPersQueue::TPQLib Pq_;
        TIntrusivePtr<NPersQueue::ILogger> Logger_;
        const NPersQueue::TConsumerSettings PqSettings_;
        NUtils::TExponentialBackoff Backoff_;
        std::atomic_bool IsRuning_;
        std::atomic<TInstant> PrevFetcherCreation_;
        TInstant LastFetcherCreation_;

        NUnistat::TSignalDiff<> DataSize_;
        NUnistat::TSignalDiff<> Errors_;
        NUnistat::TTimeStat Timestat_;
    };
}
