#include "reader.h"

#include "impl/reader_impl.h"

namespace NPassport::NLb {
    TReader::TReader(const TReaderSettings& settings)
        : Impl_(std::make_unique<TImpl>(settings))
    {
    }

    TReader::~TReader() = default;

    void TReader::StartLoop(TLoopFunc func) {
        Impl_->StartLoop(func);
    }

    void TReader::StopLoop() {
        Impl_->StopLoop();
    }

    void TReader::AddUnistat(NUnistat::TBuilder& builder) const {
        Impl_->AddUnistat(builder);
    }

    bool TReader::IsOk() const {
        return Impl_->IsOk();
    }

    const TString& TReader::GetServer() const {
        return Impl_->GetServer();
    }

    TReaderThread::~TReaderThread() {
        StopLoop();

        if (Thread_.joinable()) {
            Thread_.join();
        }
    }

    void TReaderThread::StartLoop(TReader::TLoopFunc func) {
        Thread_ = std::thread([this, func]() {
            TReader::StartLoop(func);
        });
    }

}
