#pragma once

#include <passport/infra/libs/cpp/logbroker/types.h>
#include <passport/infra/libs/cpp/logbroker/resource_dispatcher/resource_dispatcher.h>

#include <library/cpp/threading/future/future.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <functional>
#include <memory>
#include <optional>
#include <thread>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLb {
    struct TReaderSettings {
        TReaderSettings()
            : ConnectionTimeout(TDuration::Seconds(10))
            , CommitPeriod(TDuration::Seconds(5))
            , FailThreshold(TDuration::Seconds(10))
        {
        }

        TVector<TString> Topics;
        TString ClientId;
        bool ReadMirroredPartitions = false;
        TString ServerName;
        std::optional<ui16> ServerPort;
        int Threads = 3;
        size_t InflightReads = 4; // simultaneous reads inside of logbroker
        TDuration ConnectionTimeout;
        TDuration CommitPeriod;
        size_t ReadMaxBytes = 1024 * 1024;
        size_t ReadMaxCounts = 1024;
        size_t MaxMemoryUsage = 50 * 1024 * 1024;
        size_t MaxUncommittedSize = 10 * 1024 * 1024;
        double ReserveRatio = 0.1;
        std::shared_ptr<TResourceDispatcher> UncommittedMemory =
            std::make_shared<TResourceDispatcher>("lb_uncommitted_bytes");
        TDuration FailThreshold;
        int LogLevel = 7; // 0(Emergency) ... 7(Debug)
        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient;
        TString TvmDstAlias = "pq";

        TString UnistatSignalId;
    };

    class TReader {
    public:
        TReader(const TReaderSettings& settings);
        TReader(TReader&&) = default;
        virtual ~TReader();

        using TLoopFunc = std::function<void(TData&& data, NThreading::TPromise<void>)>;
        virtual void StartLoop(TLoopFunc func);
        void StopLoop();
        void AddUnistat(NUnistat::TBuilder& builder) const;

        bool IsOk() const;

        const TString& GetServer() const;

        class TImpl;

    private:
        std::unique_ptr<TImpl> Impl_;
    };

    class TReaderThread: public TReader {
    public:
        TReaderThread(const TReaderSettings& settings)
            : TReader(settings)
        {
        }

        ~TReaderThread() override;

        void StartLoop(TReader::TLoopFunc func) override;

    private:
        std::thread Thread_;
    };
    using TReaderThreadPtr = std::unique_ptr<TReaderThread>;
}
