#pragma once

#include <passport/infra/libs/cpp/unistat/builder.h>

#include <util/generic/string.h>

#include <atomic>
#include <memory>
#include <mutex>
#include <unordered_map>

namespace NPassport::NLb {
    class TResourceDispatcher {
    public:
        explicit TResourceDispatcher(const TString& unistatPrefix);

        void AddResource(const TString& id, ui64 limit, ui64 reserve = 0);

        void AddUnistat(NUnistat::TBuilder& builder);

        bool TryAcquire(const TString& id, ui64 size);
        bool Release(const TString& id, ui64 size);

    private:
        struct TResource {
            TResource(const TString& unistatPrefix, ui64 limit, ui64 reserve);

            ui64 GetRequiredReserve(ui64 required) const;

            NUnistat::TSignalAbsolute<> Limit;
            NUnistat::TSignalAbsolute<> Used;

            ui64 Requested = 0;
            ui64 Reserve = 0;
        };

    private:
        TResource& GetResource(const TString& id);

        void RequestReserve(TResource& resource, ui64 required);
        void ReleaseReserve(TResource& resource, ui64 required);

        bool TryUse(ui64 size);
        bool TryBorrow(ui64 size, ui64 borrow);
        bool TryForceBorrow(ui64 size, ui64 borrow);
        void Release(ui64 used, ui64 borrowed = 0);

    private:
        TString UnistatPrefix_;

        std::mutex Mutex_;

        NUnistat::TSignalAbsolute<> TotalLimit_;
        NUnistat::TSignalAbsolute<> TotalUsed_;
        NUnistat::TSignalAbsolute<> TotalRequired_;
        std::unordered_map<TString, std::unique_ptr<TResource>> Resources_;
    };
}
