#pragma once

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/generic/strbuf.h>

namespace NPassport::NRowParsers {
    class TField {
    public:
        TField(TStringBuf buf)
            : Buf_(buf)
        {
        }

        TField(TString&& s)
            : Allocated_(std::move(s))
            , Buf_(Allocated_)
        {
        }

        TStringBuf GetBuf() const {
            return Buf_;
        }

        const TString& GetAllocated() const {
            if (!Allocated_) {
                Allocated_ = TString(Buf_);
            }

            return Allocated_;
        }

    private:
        mutable TString Allocated_;
        TStringBuf Buf_;
    };

    class TCsvRow {
    public:
        TCsvRow() = default;
        TCsvRow(TStringBuf line);

        using TFields = TStackVec<TField, 24>;

        template <typename T>
        TStringBuf GetField(T idx) const {
            return GetField((size_t)idx);
        }

        template <typename T>
        const TString& GetAllocatedField(T idx) const {
            return GetAllocatedField((size_t)idx);
        }

        TStringBuf GetField(size_t idx) const;
        const TString& GetAllocatedField(size_t idx) const;

        size_t FieldsCount() const {
            return Fields_.size();
        }

    public:
        TString PrintDebug() const;

        static TField Unquote(TStringBuf& line, char quote = '`');
        static void SplitToFields(TStringBuf line, char delimeter, char quote, TFields& fields);

    protected:
        TFields Fields_;
    };
}
