#pragma once

#include <library/cpp/string_utils/tskv_format/tskv_map.h>

namespace NPassport::NRowParsers {
    enum class ETskvEscapePolicy {
        Unescape,
        KeepAsIs,
    };

    enum class ETskvPrefixPolicy {
        Required,
        SkipIfFound,
    };

    struct TTskvPolicy {
        ETskvEscapePolicy Escape = ETskvEscapePolicy::Unescape;
        ETskvPrefixPolicy Prefix = ETskvPrefixPolicy::Required;
    };

    class TTskvParser {
    public:
        template <typename T>
        static void Parse(TStringBuf line, T& fields, TString& buf, const TTskvPolicy& policy = {}) {
            SkipTskvPrefix(line, policy.Prefix);
            NTskvFormat::DeserializeMap(line, fields, buf, policy.Escape == ETskvEscapePolicy::Unescape);
        }

        static void SkipTskvPrefix(TStringBuf& line, ETskvPrefixPolicy policy);
    };
}
