#pragma once

#include "tskv_parser.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/string/cast.h>

#include <map>
#include <optional>

namespace NPassport::NUtils {
    class TIpAddr;
}

namespace NPassport::NRowParsers {
    class TTskvRow {
    public:
        using TFields = std::map<TStringBuf, TStringBuf>;

        TTskvRow() = default;
        TTskvRow(TStringBuf line, const TTskvPolicy& policy = {});
        TTskvRow(const TFields& fields); // for tests

        void Reset(TStringBuf line, const TTskvPolicy& policy = {});

        bool HasField(TStringBuf name) const {
            return Fields_.find(name) != Fields_.end();
        }

        TStringBuf GetField(TStringBuf name) const;
        TStringBuf GetOptionalField(TStringBuf key) const;

        template <typename Num>
        void GetNum(TStringBuf key, Num& out) const {
            TStringBuf value = GetField(key);
            Y_ENSURE(TryFromString(value, out),
                     "invalid number in '" << key << "': '" << value << "'");
        }

        template <typename Num>
        bool GetOptionalNum(TStringBuf key, Num& out) const {
            TStringBuf value = GetOptionalField(key);
            if (value.empty()) {
                return false;
            }

            Y_ENSURE(TryFromString(value, out),
                     "invalid number in '" << key << "': '" << value << "'");
            return true;
        }

        NUtils::TIpAddr GetIp(TStringBuf key) const;
        std::optional<NUtils::TIpAddr> GetOptionalIp(TStringBuf key) const;

        TInstant GetUnixtime(TStringBuf key) const;
        std::optional<TInstant> GetOptionalUnixtime(TStringBuf key) const;

        const TFields& Fields() const {
            return Fields_;
        }

        TFields& MutateFields() {
            return Fields_;
        }

        size_t FieldsCount() const {
            return Fields_.size();
        }

        TString PrintDebug() const;

        bool operator==(const TTskvRow& o) const {
            return Fields_ == o.Fields_;
        }

    protected:
        TFields Fields_;
        TString Buf_;
    };
}
