#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NRowParsers;

Y_UNIT_TEST_SUITE(RowParsersTskvParser) {
    Y_UNIT_TEST(skipTskvPrefix) {
        for (ETskvPrefixPolicy p : {
                 ETskvPrefixPolicy::Required,
                 ETskvPrefixPolicy::SkipIfFound,
             }) {
            TStringBuf line = "tskv\tuid=100500\tip=127.0.0.1";
            UNIT_ASSERT_NO_EXCEPTION(TTskvParser::SkipTskvPrefix(line, p));
            UNIT_ASSERT_VALUES_EQUAL("uid=100500\tip=127.0.0.1", line);
        }

        TStringBuf line = "uid=100500\tip=127.0.0.1";
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TTskvParser::SkipTskvPrefix(line, ETskvPrefixPolicy::Required),
            yexception,
            "line should start with 'tskv'");

        line = "uid=100500\tip=127.0.0.1";
        UNIT_ASSERT_NO_EXCEPTION(TTskvParser::SkipTskvPrefix(line, ETskvPrefixPolicy::SkipIfFound));
        UNIT_ASSERT_VALUES_EQUAL("uid=100500\tip=127.0.0.1", line);
    }
}
