#include <passport/infra/libs/cpp/logbroker/row_parsers/utils.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NRowParsers;

Y_UNIT_TEST_SUITE(RowParsersUtils) {
    Y_UNIT_TEST(timestampFromFloat) {
        TInstant ts = TUtils::TimestampFromFloat(123456.789);
        UNIT_ASSERT_VALUES_EQUAL(123456, ts.Seconds());
        UNIT_ASSERT_VALUES_EQUAL(789000, ts.MicroSecondsOfSecond());
    }

    Y_UNIT_TEST(parseUnixtime) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUtils::ParseUnixtime("kek"), yexception, "invalid unixtime: 'kek'");

        TInstant ts = TUtils::ParseUnixtime("123456.789");
        UNIT_ASSERT_VALUES_EQUAL(123456, ts.Seconds());
        UNIT_ASSERT_VALUES_EQUAL(789000, ts.MicroSecondsOfSecond());
    }
}
