#include "utils.h"

#include <util/string/cast.h>

namespace NPassport::NRowParsers {
    TInstant TUtils::TimestampFromFloat(double value) {
        ui64 integer = ui64(value);
        ui64 fractional = ui64(value * 1000000) % 1000000;

        return TInstant::Seconds(integer) + TDuration::MicroSeconds(fractional);
    }

    TInstant TUtils::ParseUnixtime(TStringBuf value) {
        double ts = 0.0;
        Y_ENSURE(TryFromString(value, ts), "invalid unixtime: '" << value << "'");
        return TimestampFromFloat(ts);
    }

}
