#pragma once

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NLb {
    struct TChunk: TMoveOnly {
        struct TMeta: TMoveOnly {
            TString File;
            TString Server;
            TInstant CreateTime;
        } Meta;

        TString Data;
    };

    struct TTopicData: TMoveOnly {
        TString Topic;
        std::vector<TChunk> Data;
    };

    struct TData: TMoveOnly {
        std::vector<TTopicData> Messages;
        TString Traceid;
    };

    using TTraceids = TStackVec<TString, 16>;
}
