#include "phonenumber.h"

#include <passport/infra/libs/cpp/utils/string/format.h>

#include <contrib/libs/libphonenumber/cpp/src/phonenumbers/phonenumberutil.h>

using namespace i18n::phonenumbers;

namespace NPassport::NPhoneNumber {
    static bool Parse(const TString& number, const TString& country, PhoneNumber& phoneNum, PhoneNumberUtil* u) {
        return PhoneNumberUtil::NO_PARSING_ERROR == u->Parse(number, country, &phoneNum) &&
               u->IsValidNumber(phoneNum);
    }

    static TString FormatImpl(const TString& rawNumber,
                              const TString& country,
                              PhoneNumberUtil::PhoneNumberFormat format) {
        try {
            auto u = PhoneNumberUtil::GetInstance();
            PhoneNumber phoneNum;
            if (!Parse(rawNumber, country, phoneNum, u)) {
                return rawNumber;
            }

            std::string result;
            u->Format(phoneNum, format, &result);
            return TString(result);
        } catch (...) {
            return rawNumber;
        }
    }

    static bool IsLegalCountry(const TString& country) {
        if (country.size() > 5) {
            return false;
        }

        auto it = std::find_if_not(country.cbegin(),
                                   country.cend(),
                                   [](char c) { return (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z'); });
        return it == country.cend();
    }

    static const TString DEFAULT_COUNTRY = "ZZ";
    TString TUtils::FormatInternational(const TString& rawNumber) {
        return FormatImpl(rawNumber, DEFAULT_COUNTRY, PhoneNumberUtil::INTERNATIONAL);
    }

    TString TUtils::FormatOnlyDigits(const TString& rawNumber, const TString& country) {
        TString res = IsLegalCountry(country)
                          ? FormatImpl(rawNumber, NUtils::ToupperCopy(country), PhoneNumberUtil::E164)
                          : rawNumber;
        if (!res.empty() && res.front() == '+') {
            res.erase(0, 1);
        }
        return res;
    }

    bool TUtils::IsValidE164(const TString& number) {
        try {
            auto u = PhoneNumberUtil::GetInstance();
            PhoneNumber phoneNum;
            return Parse(number, DEFAULT_COUNTRY, phoneNum, u);
        } catch (...) {
            return false;
        }
    }

}
