#include <passport/infra/libs/cpp/phonenumber/phonenumber.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NPhoneNumber;

Y_UNIT_TEST_SUITE(PasspPhoneNumber) {
    Y_UNIT_TEST(formatInternational) {
        UNIT_ASSERT_VALUES_EQUAL("+70002426488", TUtils::FormatInternational("+70002426488"));

        UNIT_ASSERT_VALUES_EQUAL("+7 903 242-64-88", TUtils::FormatInternational("+79032426488"));
        UNIT_ASSERT_VALUES_EQUAL("+7 903 242-64-88", TUtils::FormatInternational("+7  90 3 24 2 6 4 88"));
        UNIT_ASSERT_VALUES_EQUAL("+7 903 242-64-88", TUtils::FormatInternational("   + 7 903 242 64 88   "));
    }

    Y_UNIT_TEST(formatOnlyDigits) {
        UNIT_ASSERT_VALUES_EQUAL("79032426488", TUtils::FormatOnlyDigits("+79032426488", "RU"));
        UNIT_ASSERT_VALUES_EQUAL("996999123456", TUtils::FormatOnlyDigits("+996999123456", "абыр"));
        UNIT_ASSERT_VALUES_EQUAL("0999123456", TUtils::FormatOnlyDigits("0999123456", ""));

        UNIT_ASSERT_VALUES_EQUAL("79032426488", TUtils::FormatOnlyDigits("89032426488", "ru"));
        UNIT_ASSERT_VALUES_EQUAL("79032426488", TUtils::FormatOnlyDigits("89032426488", "RU"));

        UNIT_ASSERT_VALUES_EQUAL("0999123456", TUtils::FormatOnlyDigits("0999123456", "KG"));
        UNIT_ASSERT_VALUES_EQUAL("996554123456", TUtils::FormatOnlyDigits("0554123456", "KG"));

        UNIT_ASSERT_VALUES_EQUAL("380999999999", TUtils::FormatOnlyDigits("0999999999", "UA"));
        UNIT_ASSERT_VALUES_EQUAL("380999123456", TUtils::FormatOnlyDigits("0999123456", "UA"));

        UNIT_ASSERT_VALUES_EQUAL("0999123456", TUtils::FormatOnlyDigits("0999123456", "BY"));
        UNIT_ASSERT_VALUES_EQUAL("375172202555", TUtils::FormatOnlyDigits("0172202555", "BY"));

        UNIT_ASSERT_VALUES_EQUAL("0999123456", TUtils::FormatOnlyDigits("0999123456", "RU"));
        UNIT_ASSERT_VALUES_EQUAL("79991234567", TUtils::FormatOnlyDigits("9991234567", "RU"));

        UNIT_ASSERT_VALUES_EQUAL("05999123456", TUtils::FormatOnlyDigits("05999123456", "TR"));
        UNIT_ASSERT_VALUES_EQUAL("902123868760", TUtils::FormatOnlyDigits("02123868760", "TR"));
    }

    Y_UNIT_TEST(isValid) {
        // ru
        UNIT_ASSERT(TUtils::IsValidE164("+79161112233"));
        UNIT_ASSERT(TUtils::IsValidE164("+79032426488"));
        UNIT_ASSERT(!TUtils::IsValidE164("+70002426488"));
        UNIT_ASSERT(!TUtils::IsValidE164("+70999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("09032426488"));
        UNIT_ASSERT(!TUtils::IsValidE164("+09032426488"));
        UNIT_ASSERT(!TUtils::IsValidE164("+9032426488"));

        // kg
        UNIT_ASSERT(TUtils::IsValidE164("+996554123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+996999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("0554123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+0554123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+554123456"));

        // ua
        UNIT_ASSERT(TUtils::IsValidE164("+380999999999"));
        UNIT_ASSERT(TUtils::IsValidE164("+380999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("0999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+0999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+999123456"));

        // by
        UNIT_ASSERT(TUtils::IsValidE164("+375172202555"));
        UNIT_ASSERT(!TUtils::IsValidE164("+375999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("0999123456"));

        // tr
        UNIT_ASSERT(TUtils::IsValidE164("+902123868760"));
        UNIT_ASSERT(!TUtils::IsValidE164("+905999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("05999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+05999123456"));
        UNIT_ASSERT(!TUtils::IsValidE164("+5999123456"));
    }
}
