#include <passport/infra/libs/cpp/re2/regex.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/string/subst.h>

using namespace NPassport;

const TString patt = "{lol} My {abc} mega {lol} with extensions {qwe}";

const TString key1 = "{abc}";
const TString key2 = "{qwe}";
const TString key3 = "{lol}";

const TString val1 = "123455";
const TString val2 = "1";
const TString val3 = "123455asx";
const std::vector<TString> vals = {val1, val2, val3};

const NPassport::NRe2::TPattern ppattern = NPassport::NRe2::TPattern::WithCustomPlaceholders(
    patt,
    {key1, key2, key3});

const TString expectedString = "123455asx My 123455 mega 123455asx with extensions 1";

Y_CPU_BENCHMARK(replace, iface) {
    for (size_t i = 0; i < iface.Iterations(); ++i) {
        TString s = patt;
        SubstGlobal(s, key1, val1);
        SubstGlobal(s, key2, val2);
        SubstGlobal(s, key3, val3);
        Y_ENSURE(s == expectedString, s);
    }
}

Y_CPU_BENCHMARK(pattern, iface) {
    for (size_t i = 0; i < iface.Iterations(); ++i) {
        TString s = ppattern.BuildString(vals);
        Y_ENSURE(s == expectedString, s);
    }
}
