#include "mapper.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/string/split.h>
#include <util/system/shellcommand.h>

namespace NPassport::NReporter {
    TVector<TString> TMapper::GetLogList(const TString& storage,
                                         const TString& date,
                                         const TString& filename,
                                         const std::vector<TString>& exclude,
                                         EPolicy policy) {
        TString params;
        for (const TString& e : exclude) {
            if (params) {
                NUtils::Append(params, " -and");
            }
            if (policy == EPolicy::Exclude) {
                NUtils::Append(params, " -not");
            }
            NUtils::Append(params, " -path ", e);
        }

        TString c = TStringBuilder()
                    << "find " << storage
                    << " -type f"
                    << " -name " << filename << "." << date << "*"
                    << params;

        TStringStream out;
        TShellCommand cmd(c, TShellCommandOptions().SetOutputStream(&out));
        cmd.Run();

        Y_ENSURE(cmd.GetExitCode() && *cmd.GetExitCode() == 0, "cmd failed: " << c);
        Y_ENSURE(!cmd.GetError());

        TVector<TString> res;
        Split(out.Str(), "\n", res);
        Y_ENSURE(!res.empty(), "Logs not found: " << c);
        Cout << "Found files: " << res.size() << Endl;
        return res;
    }
}
