#include "parser.h"

#include <library/cpp/streams/xz/decompress.h>

#include <util/stream/zlib.h>

namespace NPassport::NReporter {
    TParserBase::TParserBase(const TString& filename)
        : Filename_(filename)
        , File_(filename)
        , In_(&File_)
    {
        if (filename.EndsWith(".gz")) {
            Zip_ = std::make_unique<TBufferedZLibDecompress>(&File_);
            In_ = Zip_.get();
        } else if (filename.EndsWith(".xz")) {
            Xz_ = std::make_unique<TXzDecompress>(&File_);
            In_ = Xz_.get();
        }
    }

    TParserBase::~TParserBase() = default;

    void TParserBase::Parse() {
        TString line;
        while (In_->ReadLine(line) > 0) {
            Size_ += line.size() + 1; // + \n
            try {
                ParseLine(line);
            } catch (const std::exception& e) {
                Cerr << "Exception: " << e.what()
                     << ". File: " << Filename_
                     << ". Line: '" << line << "'" << Endl;
            }
        }
    }
}
