#pragma once

#include <util/stream/file.h>

#include <memory>

class TBufferedZLibDecompress;
class TXzDecompress;

namespace NPassport::NReporter {
    class TParserBase {
    public:
        TParserBase(const TString& filename);
        ~TParserBase();

        void Parse();

        size_t GetSize() const {
            return Size_;
        }

        virtual void ParseLine(TStringBuf line) = 0;

    protected:
        const TString Filename_;

    private:
        TFileInput File_;
        std::unique_ptr<TBufferedZLibDecompress> Zip_;
        std::unique_ptr<TXzDecompress> Xz_;
        IInputStream* In_;
        size_t Size_ = 0;
    };
}
