#pragma once

#include <util/generic/string.h>

#include <cctype>
#include <functional>
#include <unordered_map>

namespace NPassport::NCommon {
    // For MDA
    struct TCiStrHash {
        size_t operator()(const TString& x) const {
            size_t hash = 0;
            for (const char c : x) {
                hash += std::hash<char>()(std::toupper(c));
            }
            return hash;
        }
    };

    struct TCiStrEqual {
        bool operator()(const TString& x, const TString& y) const {
            if (x.size() != y.size()) {
                return false;
            }

            TString::const_iterator xit = x.cbegin();
            TString::const_iterator yit = y.cbegin();
            while (xit != x.cend()) {
                if (std::toupper(*xit++) != std::toupper(*yit++)) {
                    return false;
                }
            }

            return true;
        }
    };

    using THttpHeaders = std::unordered_map<TString, TString, TCiStrHash, TCiStrEqual>;
}
