#pragma once

#include <util/generic/string.h>

namespace NPassport::NCommon {
    struct TExtendedArg {
        TExtendedArg() = default;

        template <typename T>
        TExtendedArg(T&& val, bool isGet = false)
            : Value(std::forward<T>(val))
            , IsGet(isGet)
        {
        }

        template <typename T>
        TExtendedArg& operator=(T&& val) {
            Value = std::forward<T>(val);
            return *this;
        }

        TString Value;
        bool IsGet = false;
    };
}
