#pragma once

#include <passport/infra/libs/cpp/request/ci_map.h>
#include <passport/infra/libs/cpp/request/request.h>

#include <passport/infra/libs/cpp/utils/thread_local_id.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>
#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/http/server/http.h>

#include <util/generic/string.h>

#include <map>
#include <unordered_map>
#include <vector>

namespace NPassport::NHttp {
    class TRequest: public NCommon::TRequest {
    public:
        class TMethodException: public std::runtime_error {
            using std::runtime_error::runtime_error;
        };

    public:
        explicit TRequest(const TRequestReplier::TReplyParams& params, const TRequestReplier& parent);
        ~TRequest() override;

        void Flush(const TStackVec<THttpInputHeader, 2>& extraHeaders = {});

        bool HasHeader(const TString& name) const override;
        const TString& GetHeader(const TString& name) const override;
        NCommon::THttpHeaders GetAllHeaders() const override;
        bool HasCookie(const TString& name) const override;
        const TString& GetCookie(const TString& name) const override;
        bool HasArg(const TString& name) const override;
        const TString& GetArg(const TString& name) const override;
        const NCommon::TExtendedArg& GetExtendedArg(const TString& name) const override;
        void ArgNames(std::vector<TString>& v) const override;

        const TString& GetRemoteAddr() const override;
        TString GetUri() const override;
        const TString& GetPath() const override;
        const TString& GetQueryString() const override;
        const TString& GetRequestMethod() const override;
        const TString& GetRequestId() const override;

        void ScanCgiFromBody() override;
        void ForceProvideRequestId() override;
        TDuplicatedArgs GetDuplicatedArgs() const override;

        bool IsSecure() const override;
        const TString& GetHost() const override;
        bool IsBodyEmpty() const override;

        void SetStatus(HttpCodes code) override;
        void SetHeader(const TString& name, const TString& value) override;
        void SetCookie(const NCommon::TCookie& cookie) override;
        void Write(const TString& body) override;

        HttpCodes GetStatusCode() const override;
        size_t GetResponseSize() const override;

        const TString& GetRequestBody() const override;
        TStringBuf GetRequestCgi() const override;

    private:
        void InitHeaders();
        void LazyCookies() const;
        void LazyPath() const;
        void LazyQueryString() const;
        void LazyRemoteAddr() const;
        void InitRequestId();

        enum class EArgSource {
            Get,
            Body,
        };
        void ScanCgi(TStringBuf str, EArgSource source);

    private:
        const TRequestReplier::TReplyParams& Params_;
        const TRequestReplier& Parent_;
        const TParsedHttpFull FirstLine_;
        TString Body_;
        TString Method_;

        std::unordered_multimap<TString, NCommon::TExtendedArg> Cgi_;
        NCommon::THttpHeaders Headers_;
        TString ReqId_;

        mutable struct TLazy {
            std::unordered_map<TString, TString> Cookies;
            TString Path;
            TString QueryString;
            TString RemoteAddr;
            TString CacheKey;
        } Lazy_;

        struct TBufferedOut {
            HttpCodes Code = HTTP_OK;
            TString Body;
            TString ContentType;
            std::vector<THttpInputHeader> Headers;
            std::map<TString, NCommon::TCookie> Cookies;
        } Out_;

        NUtils::TRequestIdGuard RequestIdGuard_;
    };

}
