#pragma once

#include "ci_map.h"
#include "cookie.h"
#include "extended_arg.h"

#include <library/cpp/http/misc/httpcodes.h>

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NCommon {
    class TRequest {
    public:
        using TDuplicatedArgs = std::vector<std::pair<TStringBuf, TStringBuf>>;

        TRequest()
            : Consumer_("-")
        {
        }

        virtual ~TRequest() {
        }
        virtual bool HasHeader(const TString& name) const = 0;
        virtual const TString& GetHeader(const TString& name) const = 0;
        virtual THttpHeaders GetAllHeaders() const = 0;
        virtual bool HasCookie(const TString& name) const = 0;
        virtual const TString& GetCookie(const TString& name) const = 0;
        virtual bool HasArg(const TString& name) const = 0;
        virtual const TString& GetArg(const TString& name) const = 0;
        virtual const TExtendedArg& GetExtendedArg(const TString& name) const = 0;
        virtual const TString& GetRemoteAddr() const = 0;
        virtual const TString& GetPath() const = 0;
        virtual const TString& GetQueryString() const = 0;
        virtual const TString& GetRequestMethod() const = 0;
        virtual bool IsSecure() const = 0;
        virtual const TString& GetHost() const = 0;
        virtual TString GetUri() const = 0;

        virtual bool IsBodyEmpty() const = 0;

        virtual const TString& GetRequestId() const = 0;
        virtual void ArgNames(std::vector<TString>& v) const = 0;
        virtual void ScanCgiFromBody() = 0;
        virtual void ForceProvideRequestId() = 0;
        virtual TDuplicatedArgs GetDuplicatedArgs() const = 0;

        virtual void SetStatus(HttpCodes code) = 0;
        virtual void SetHeader(const TString& name, const TString& value) = 0;
        virtual void SetCookie(const TCookie& cookie) = 0;
        virtual void Write(const TString& body) = 0;

        virtual HttpCodes GetStatusCode() const = 0;
        virtual size_t GetResponseSize() const = 0;

        virtual const TString& GetRequestBody() const = 0;
        virtual TStringBuf GetRequestCgi() const = 0;

    public:
        TString GetUrl() const {
            TString url(IsSecure() ? "https://" : "http://");
            url.append(GetHost()).append(GetUri());
            return url;
        }

        void SetConsumerFormattedName(TString&& consumer) {
            Consumer_ = std::move(consumer);
        }

        const TString& GetConsumerFormattedName() const {
            return Consumer_;
        }

    private:
        TString Consumer_;
    };
}
