#include <passport/infra/libs/cpp/request/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NCommon;

Y_UNIT_TEST_SUITE(PassportRequestCommon) {
    Y_UNIT_TEST(cookie) {
        TCookie c("yandex_login", "test-user");
        UNIT_ASSERT_VALUES_EQUAL("yandex_login=test-user; path=/", c.ToString());

        TCookie tmp("yandex", "a=b*c");
        UNIT_ASSERT(tmp < c);
        UNIT_ASSERT(!tmp.UrlEncode());
        UNIT_ASSERT_VALUES_EQUAL("yandex=a=b*c; path=/", tmp.ToString());

        tmp.SetUrlEncode(true);
        UNIT_ASSERT(tmp.UrlEncode());
        UNIT_ASSERT_VALUES_EQUAL("yandex=a%3Db%2Ac; path=/", tmp.ToString());

        c.SetDomain("yandex.ru");
        c.SetPath("/passport");
        c.SetSecure(true);
        c.SetExpires(1515151515);
        c.SetPermanent(true);
        c.SetHttpOnly(true);
        c.SetSameSite(TCookie::ESameSite::Strict);

        UNIT_ASSERT_VALUES_EQUAL("yandex_login", c.Name());
        UNIT_ASSERT_VALUES_EQUAL("test-user", c.Value());
        UNIT_ASSERT_VALUES_EQUAL("yandex.ru", c.Domain());
        UNIT_ASSERT_VALUES_EQUAL("/passport", c.Path());
        UNIT_ASSERT_VALUES_EQUAL(true, c.Secure());
        UNIT_ASSERT_VALUES_EQUAL(2147483647, c.Expires());
        UNIT_ASSERT_VALUES_EQUAL(true, c.Permanent());
        UNIT_ASSERT_VALUES_EQUAL(true, c.HttpOnly());
        UNIT_ASSERT(c.SameSite());
        UNIT_ASSERT_VALUES_EQUAL(TCookie::ESameSite::Strict, *c.SameSite());

        UNIT_ASSERT_VALUES_EQUAL("yandex_login=test-user; domain=yandex.ru; path=/passport; expires=Tue, 19 Jan 2038 03:14:07 GMT; SameSite=Strict; secure; HttpOnly", c.ToString());

        TCookie c2(c);
        UNIT_ASSERT_VALUES_EQUAL("yandex_login=test-user; domain=yandex.ru; path=/passport; expires=Tue, 19 Jan 2038 03:14:07 GMT; SameSite=Strict; secure; HttpOnly", c2.ToString());

        c2 = tmp;
        UNIT_ASSERT_VALUES_EQUAL("yandex=a%3Db%2Ac; path=/", c2.ToString());

        c2.SetExpires(std::numeric_limits<time_t>::max());
        UNIT_ASSERT_VALUES_EQUAL(9223372036854775807L, c2.Expires());
    }

    Y_UNIT_TEST(formatTime) {
        class TTestCookie: public TCookie {
        public:
            using TCookie::FormatTime;
        };

        UNIT_ASSERT_STRINGS_EQUAL("Fri, 02 Jan 1970 03:55:00 GMT", TTestCookie::FormatTime(100500));
    }
}
