#pragma once

#include <util/datetime/base.h>
#include <util/folder/path.h>
#include <util/system/file.h>

#include <deque>

namespace NPassport::NTail {
    class THistory {
    public:
        struct TRecord {
            TInstant Timestamp;
            ui64 Value = 0;
        };

        THistory(size_t maxHistorySize = 1024);
        virtual ~THistory() = default;

        bool AddRecord(ui64 value, TInstant now = TInstant::Now());
        void DropRecords(ui64 value);
        void Reset();

        TDuration GetLag(TInstant now = TInstant::Now()) const;

        const std::deque<TRecord>& GetHistory() const {
            return History_;
        }

    private:
        const size_t MaxHistorySize_;
        ui64 ReachedValue_ = 0;
        std::deque<TRecord> History_;
    };

    class THistoryCache {
    public:
        static bool Read(const TFsPath& path, ui64 index, THistory& history);
        static bool Write(const TFsPath& path, ui64 index, const THistory& history);
    };
}
