#pragma once

#include <util/generic/string.h>
#include <util/stream/file.h>
#include <util/system/filemap.h>

#include <optional>

namespace NPassport::NTail {
    struct TLine {
        ui64 Offset = 0;
        TStringBuf Line;
    };

    class TTail {
    public:
        explicit TTail(const TFile& file);

        size_t SkipAll();
        size_t JumpTo(size_t bytes);

        std::optional<TLine> ReadLine();

        size_t Offset() const;

    private:
        bool ReadMore();
        std::optional<TLine> TrySplitLine();

    private:
        TFileMap Mapper_;
        TMemoryMapCommon::TMapResult MapRegion_;

        i64 PosInFile_ = 0;
        size_t PosInMapped_ = 0;
    };
}
