#include "decryptor.h"

#include <passport/infra/libs/cpp/utils/crypto/hash.h>
#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/split.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <contrib/libs/openssl/include/openssl/evp.h>

namespace NPassport::NTvmCommon {
    TString TDecryptor::DecryptAes(const TString& str, const char* detail, ui64 id) const {
        // No encryption
        if (str.at(1) != ':') {
            return str;
        }

        // AES-256 with single key
        if (str.at(0) != '1' && str.at(0) != '2') {
            TLog::Debug("DbFetcher: decryptAES: unexpected version: %c. %s : %lu", str.at(0), detail, id);
            return TString();
        }

        auto vec = NUtils::ToVector<TStringBuf>(str, ':');
        if (vec.size() != 4) {
            TLog::Debug("DbFetcher: decryptAES: unexpected format. %s : %lu", detail, id);
            return TString();
        }

        NUtils::TCrypto::TCiphertext ctext;

        ctext.Iv = NUtils::Base64url2bin(vec.at(1));
        ctext.Text = NUtils::Base64url2bin(vec.at(2));
        ctext.Tag = NUtils::Base64url2bin(vec.at(3));

        TString plainText;
        TString err_msg;

        if (!NUtils::TCrypto::DecryptGcm(AesKey_, ctext, plainText, &err_msg)) {
            TLog::Debug("DbFetcher: decryptAES: %s. %s : %lu", err_msg.c_str(), detail, id);
            return TString();
        }

        if (str.at(0) == '2') {
            if (plainText.size() < 8) {
                TLog::Debug("DbFetcher: id can't be less than 8 bytes. %s : %lu", detail, id);
                return {};
            }

            ui64 protectedId = NUtils::FromBytesMsb<ui64>(TStringBuf(plainText).Last(8));
            if (protectedId != id) {
                TLog::Debug("DbFetcher: protectedId (%lu) mismatch. %s : %lu", protectedId, detail, id);
                return TString();
            }
            plainText.resize(plainText.size() - 8);
        }

        return plainText;
    }

    TString TEncryptor::EncryptAes(const TString& d, const ui64 id) const {
        TString data = d;
        if (0 != id) {
            size_t pos = data.size();
            data.resize(data.size() + 8, 0);
            NUtils::ToBytesMsb(id, data, pos);
        }

        NUtils::TCrypto::TCiphertext encr;
        Y_ENSURE(NUtils::TCrypto::EncryptGcm(AesKey_, data, encr));

        return NUtils::CreateStr(
            0 == id ? "1" : "2",
            ":",
            NUtils::Bin2base64url(encr.Iv),
            ":",
            NUtils::Bin2base64url(encr.Text),
            ":",
            NUtils::Bin2base64url(encr.Tag));
    }
}
