#pragma once

#include <util/generic/string.h>
#include <util/system/types.h>

namespace NPassport::NTvmCommon {
    class TDecryptor {
    public:
        TDecryptor(const TString& aesKey)
            : AesKey_(aesKey)
        {
        }

        TString DecryptAes(const TString& str, const char* detail, ui64 id) const;

    private:
        const TString AesKey_;
    };

    class TEncryptor {
    public:
        TEncryptor(const TString& aesKey)
            : AesKey_(aesKey)
        {
        }

        TString EncryptAes(const TString& data, const ui64 id = 0) const;

    private:
        const TString AesKey_;
    };
}
