#pragma once

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <library/cpp/tvmauth/checked_user_ticket.h>

#include <util/datetime/base.h>
#include <util/folder/path.h>

#include <functional>

namespace NTvmAuth {
    class TTvmClient;
}

namespace NTvmAuth::NRw {
    class TRwPrivateKey;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NTvmCommon {
    using TKeyId = ui32;

    class TPrivateKeyFetcher;

    struct TPrivateKeySettings {
        TString TvmHost = "https://tvm-api.yandex.net";
        ui32 TvmPort = 443;

        TString TvmCacheDir;
        TDuration CacheTtl = TDuration::Days(5);
        bool EnableDiskCache = true;

        TDuration JugglerWarningTimeout = TDuration::Hours(3);
        TDuration JugglerCriticalTimeout = TDuration::Days(1);

        size_t PreferredKeyIdx = 0;

        TDuration Period = TDuration::Hours(1);
        TDuration RetryPeriod = TDuration::Minutes(1);
        NTvmAuth::EBlackboxEnv Env = NTvmAuth::EBlackboxEnv::Prod;
    };

    class TPrivateKey {
    public:
        struct TStampedPrivateKey {
            TInstant Ts;
            TString Data;
        };

        using TKey = std::shared_ptr<NTvmAuth::NRw::TRwPrivateKey>;

        TPrivateKey(TPrivateKeySettings&& settings,
                    std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);
        virtual ~TPrivateKey() = default;

        void Run();

        TKey GetKey() const;

        void SelfCheck(time_t now = time(nullptr) + 3600) const;

        NJuggler::TStatus GetJugglerStatus() const;

        // TODO: move to utils?
        static void ChooseKey(std::vector<TKeyId>&& keyIds,
                              size_t preferredKeyIdx,
                              std::function<bool(const TKeyId)> func);

        static NTvmAuth::EBlackboxEnv TranslateEnv(const TString& name);

    private:
        void Update();
        void UpdateKeys(const TStampedPrivateKey& key);
        TKey Parse(const TStringBuf privateKey) const;

        TStampedPrivateKey FetchFromApi(const TString& serviceTicket) const;
        TStampedPrivateKey FetchFromCache() const;

        const TPrivateKeySettings Settings_;

        const TFsPath PublicKeysCacheFile_;
        const TFsPath PrivateKeysCacheFile_;

        const std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;

        NUtils::TSharedState<NTvmAuth::NRw::TRwPrivateKey> Key_;
        NUtils::TSharedState<TInstant> LastUpdateTs_;
        NUtils::TSharedState<TString> LastErrorMessage_;
    };

}
