#pragma once

#include <passport/infra/libs/cpp/utils/file.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <library/cpp/tvmauth/type.h>
#include <library/cpp/tvmauth/deprecated/service_context.h>
#include <library/cpp/tvmauth/deprecated/user_context.h>

#include <util/generic/string.h>

#include <optional>

namespace NPassport::NTvmCommon {
    class TPublicKeys {
    public:
        TPublicKeys(const TString& keyfile,
                    TDuration period,
                    NTvmAuth::TTvmId selfClientId,
                    NTvmAuth::EBlackboxEnv env);
        TPublicKeys(const TString& keyfile,
                    TDuration period,
                    NTvmAuth::TTvmId selfClientId);
        ~TPublicKeys();

        NTvmAuth::TCheckedServiceTicket CheckServiceTicket(const TStringBuf ticket) const;
        NTvmAuth::TCheckedUserTicket CheckUserTicket(const TString& ticket) const;
        NTvmAuth::TTvmId GetSelfClientId() const;

    private:
        using TOptUserCtx = std::optional<NTvmAuth::TUserContext>;
        struct TContexts {
            NTvmAuth::TServiceContext Serv;
            TOptUserCtx User;
        };

        using TCtx = std::shared_ptr<TContexts>;

        void Update(const TStringBuf fileBody);
        TCtx Parse(const TStringBuf fileBody) const;

        const TString File_;
        const NTvmAuth::TTvmId SelfClientId_;
        const std::optional<NTvmAuth::EBlackboxEnv> Env_;
        NUtils::TSharedState<TContexts> Ctx_;

        // must be last member
        std::unique_ptr<NUtils::TFileLoader> Loader_;
    };
}
