#pragma once

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <atomic>
#include <map>
#include <memory>
#include <vector>

namespace NPassport::NUtils {
    class TFileLoader;
}

namespace NPassport::NTvmCommon {
    class TServiceTickets {
    public:
        using TDsts = std::vector<TString>;

        static const TString BLACKBOX_;
        static const TString ISSNKMS_;
        static const TString KOLMOGOR_;
        static const TString LOGBROKER_;
        static const TString TVMAPI_;
        static const TString PASSPORTAPI_;
        static const TString STAFFAPI_;

        TServiceTickets(const TString& filename,
                        const TDsts& dst,
                        TDuration period);
        ~TServiceTickets();

        TString GetServiceTicket(const TString& dst) const;
        bool IsOk(TString& out) const;

    private:
        using TTickets = std::map<TString, TString>; // dst, service ticket
        using TTicketsPtr = std::shared_ptr<TTickets>;

        void Update(const TStringBuf fileBody);
        TServiceTickets::TTicketsPtr Parse(const TStringBuf fileBody) const;
        void CheckDsts(const TTickets& t) const;

    private:
        const TString Filename_;
        const TDsts Dst_;
        NUtils::TSharedState<TTickets> ServiceTickets_;
        std::atomic<TInstant> Mtime_ = {{}};

        // must be last member
        std::unique_ptr<NUtils::TFileLoader> Refresher_;
    };
}
