#include <passport/infra/libs/cpp/tvm/common/decryptor.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NTvmCommon;

Y_UNIT_TEST_SUITE(Decryptor) {
    const TString DATA = "SkIvjQq9ZJ_aLHVDb43osg";
    const TString AES_KEY = "BtniSXCXhroPtOgXA61i5ZxSeX/solWR";

    Y_UNIT_TEST(Decr) {
        TDecryptor d(AES_KEY);

        UNIT_ASSERT_STRINGS_EQUAL(
            DATA,
            d.DecryptAes("2:jQXdcsu-on50YYqe:pAY0A3XFjZSkcKw_767NsT9MhmFDWg_EfKc6AUAv:llblpP6J-kIe7szkZDMl7g",
                         "ololo",
                         27));
        UNIT_ASSERT_STRINGS_EQUAL(
            DATA,
            d.DecryptAes("1:c3B_ZkHzP8IeDb5Z:eEAB8xbkV83ORcsGEfuTgz6ZWZNZ7A:taGiBowXUOi5mNXMZeSgWA",
                         "ololo",
                         27));
        UNIT_ASSERT_STRINGS_EQUAL("foo", d.DecryptAes("foo", "ololo", 27));

        // Unsupported version
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("3:c3B_ZkHzP8IeDb5Z:eEAB8xbkV83ORcsGEfuTgz6ZWZNZ7A:taGiBowXUOi5mNXMZeSgWA",
                         "ololo",
                         27));
        // Failed to decrypt
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("1:c3B_ZkHzP8IeDb57:eEAB8xbkV83ORcsGEfuTgz6ZWZNZ7A:taGiBowXUOi5mNXMZeSgWA",
                         "ololo",
                         27));
        // wrong id
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("2:jQXdcsu-on50YYqe:pAY0A3XFjZSkcKw_767NsT9MhmFDWg_EfKc6AUAv:llblpP6J-kIe7szkZDMl7g",
                         "ololo",
                         100500));
        // too many fields
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("2:jQXdcsu-on50YYqe:pAY0A3XFjZSkcKw_767NsT9MhmFDWg_EfKc6AUAv:llblpP6J-kIe7szkZDMl7g:aasdasdadsd",
                         "ololo",
                         27));
        // too few fields
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("2:jQXdcsu-on50YYqe:pAY0A3XFjZSkcKw_767NsT9MhmFDWg_EfKc6AUAv",
                         "ololo",
                         27));
        // too short encrypted value to check id
        UNIT_ASSERT_STRINGS_EQUAL(
            "",
            d.DecryptAes("2:yXxQ5pVYiUxDvCl_:jii_:xNPbFzWeXlt3ByuSIcxp8w",
                         "ololo",
                         27));
    }

    Y_UNIT_TEST(Encr) {
        TEncryptor e(AES_KEY);
        TDecryptor d(AES_KEY);

        UNIT_ASSERT_STRINGS_EQUAL(DATA, d.DecryptAes(e.EncryptAes(DATA), "ololo", 0)); // 1:
        ui64 id = 1159829827872332348L;
        UNIT_ASSERT_STRINGS_EQUAL(DATA, d.DecryptAes(e.EncryptAes(DATA, id), "ololo", id)); // 2:
        id = 11;
        UNIT_ASSERT_STRINGS_EQUAL(DATA, d.DecryptAes(e.EncryptAes(DATA, id), "ololo", id)); // 2:
    }
}
