#include <passport/infra/libs/cpp/tvm/common/public_keys.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/tvmauth/exception.h>

static inline TString GetFile(TString name) {
    return (ArcadiaSourceRoot() + "/passport/infra/libs/cpp/tvm/common/ut/" + name).data();
}

using namespace NPassport::NTvmCommon;

Y_UNIT_TEST_SUITE(TvmCommonPublic) {
    static const TString servTicket = "3:serv:CBAQ__________9_IhcIDBAcGgdiYjpzZXNzGghiYjpzZXNzMg:OKjKEbygehEZWH0XEeLzvf0q0aS0VvSk_CKSXGdpqxPbE4RzU70jeM-X9rXVpbYjt76VgBLlBpumJdyiclulfGPDPiL8nwJuu8AnWIR_o-QqyXbsloo2_syE6w2aYw2Yw_5_qjnipYdxGUWegHAGCj3yeMde6O2BmNZ0OCfg6qU";
    static const TString userTicket = "3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW8VrHa6ifi40wJfJMGBUcpVUxDiV2vcPGgRHUJsEGwsSoWPAMQldGoMcY_zXIbMTj-gCW2Tx84CXmLnoKItXJhTRvD6nXElCXYscBu24HUbcV7lyeereo4Q-69xz8mKQ6-c2c-USrVdAxVZOD4-FtnGpUxb6BZkP-k";

    Y_UNIT_TEST(publicKey) {
        UNIT_ASSERT_EXCEPTION(TPublicKeys(
                                  GetFile("bad.private"),
                                  TDuration::Seconds(3600),
                                  123,
                                  NTvmAuth::EBlackboxEnv::Prod),
                              NTvmAuth::TMalformedTvmKeysException);
        UNIT_ASSERT_EXCEPTION(TPublicKeys(
                                  GetFile("ok.private"),
                                  TDuration::Seconds(3600),
                                  123,
                                  NTvmAuth::EBlackboxEnv::Prod),
                              yexception);
        UNIT_ASSERT_EXCEPTION(TPublicKeys(
                                  GetFile("bad.public"),
                                  TDuration::Seconds(3600),
                                  123,
                                  NTvmAuth::EBlackboxEnv::Prod),
                              NTvmAuth::TMalformedTvmKeysException);

        TPublicKeys pk(GetFile("ok.public"),
                       TDuration::Seconds(3600),
                       28,
                       NTvmAuth::EBlackboxEnv::Prod);

        TPublicKeys pk2(GetFile("ok.public"),
                        TDuration::Seconds(3600),
                        123,
                        NTvmAuth::EBlackboxEnv::Test);

        TPublicKeys pk3(GetFile("ok.public"),
                        TDuration::Seconds(3600),
                        28);

        UNIT_ASSERT(bool(pk.CheckServiceTicket(servTicket)));
        UNIT_ASSERT_EQUAL(12, pk.CheckServiceTicket(servTicket).GetSrc());
        UNIT_ASSERT(!bool(pk.CheckServiceTicket(userTicket)));
        UNIT_ASSERT(!pk.CheckUserTicket(userTicket));

        UNIT_ASSERT(!bool(pk2.CheckServiceTicket(servTicket)));
        UNIT_ASSERT(!bool(pk2.CheckServiceTicket(userTicket)));
        UNIT_ASSERT(pk2.CheckUserTicket(userTicket));

        UNIT_ASSERT(bool(pk3.CheckServiceTicket(servTicket)));
        UNIT_ASSERT_EXCEPTION(pk3.CheckUserTicket(userTicket), yexception);
    }
}
