#include <passport/infra/libs/cpp/tvm/common/service_tickets.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvmCommon;

Y_UNIT_TEST_SUITE(TestServiceTickets) {
    static TString GetFile(TString name) {
        return ArcadiaSourceRoot() + "/passport/infra/libs/cpp/tvm/common/ut/" + name;
    }

    Y_UNIT_TEST(strings) {
        UNIT_ASSERT_VALUES_EQUAL("blackbox", TServiceTickets::BLACKBOX_);
        UNIT_ASSERT_VALUES_EQUAL("kolmogor", TServiceTickets::KOLMOGOR_);
    }

    Y_UNIT_TEST(bad) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TServiceTickets(GetFile("missing"), {}, TDuration::Seconds(1)),
                                       yexception,
                                       "can't open ");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TServiceTickets(GetFile("ok.private"), {}, TDuration::Seconds(1)),
                                       yexception,
                                       "Failed to parse json with service tickets");

        UNIT_ASSERT_EXCEPTION_CONTAINS(TServiceTickets(GetFile("service.tickets"), {"123"}, TDuration::Seconds(1)),
                                       yexception,
                                       "Required service ticket is absent: 123");
    }

    Y_UNIT_TEST(ok) {
        TServiceTickets s(GetFile("service.tickets"), {"kolmogor"}, TDuration::Seconds(1));

        UNIT_ASSERT_VALUES_EQUAL("3:serv:lol", s.GetServiceTicket("kolmogor"));
        UNIT_ASSERT_VALUES_EQUAL("3:serv:lol2", s.GetServiceTicket("blackbox"));
        UNIT_ASSERT_EXCEPTION_CONTAINS(s.GetServiceTicket("kek"),
                                       yexception,
                                       "Cannot find service ticket for dst: kek");
    }
}
