#include "create_service_ticket_opt.h"

namespace NPassport::NTvmDbPool {
    NDbPool::TQueryOpt CreateServiceTicketOpt(
        std::shared_ptr<NTvmAuth::TTvmClient> tvmClient,
        const NTvmAuth::TClientSettings::TAlias& dst) {
        return [tvmClient, dst](NDbPool::TQuery& query) {
            if (tvmClient) {
                query.AddHttpHeader(
                    NDbPool::TQuery::X_YA_SERVICE_TICKET,
                    tvmClient->GetServiceTicketFor(dst));
            }
        };
    }
}
