#include "logger.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NTvmLogger {
    void TLogger::Log(int lvl, const TString& msg) {
        void (*func)(const char*, ...);

        switch (lvl) {
            case 0:
            case 1:
            case 2:
            case 3:
                func = TLog::Error;
                break;
            case 4:
                func = TLog::Warning;
                break;
            case 5:
            case 6:
                func = TLog::Info;
                break;
            case 7:
                func = TLog::Debug;
                break;
            default:
                TLog::Error("Unexpected log level: %d", lvl);
                func = TLog::Error;
                break;
        }

        (*func)("TvmClient: %s", msg.c_str());
    }

    TIntrusivePtr<TLogger> TLogger::Create() {
        return MakeIntrusive<TLogger>();
    }
}
