#pragma once

#include "diff.h"

#include <passport/infra/libs/cpp/utils/atomic.h>

namespace NPassport::NUnistat::NSuffix {
    static const inline TString AVVV = "avvv";
    static const inline TString AXXX = "axxx";
}

namespace NPassport::NUnistat {
    // Can be freely used from any thread
    template <typename T = ui64>
    class TSignalAbsolute: public TSignalDiff<T> {
        using TBase = TSignalDiff<T>;

    public:
        TSignalAbsolute(const TString& name, const TString& suffix = NSuffix::AVVV)
            : TBase(name, suffix)
        {
        }

        void operator-=(T value) {
            TBase::Value_.SubValue(value);
        }

        T operator--() {
            return --TBase::Value_;
        }

        TSignalAbsolute<T>& operator=(T value) {
            TBase::Value_.StoreValue(value);
            return *this;
        }
    };

    // Cheap version of TSignalAbsolute
    // All modifying operators and flush() must me called from the same thread
    template <typename T = ui64>
    class TSignalBufferedAbsolute: public TSignalBufferedDiff<T> {
        using TBase = TSignalBufferedDiff<T>;

    public:
        TSignalBufferedAbsolute(const TString& name, const TString& suffix = NSuffix::AVVV)
            : TBase(name, suffix)
        {
        }

        void operator-=(T value) {
            TBase::BufferedValue_ -= value;
        }

        T operator--() {
            return --TBase::bufferedValue_;
        }

        TSignalBufferedAbsolute<T>& operator=(T value) {
            TBase::bufferedValue_ = value;
            return *this;
        }
    };
}
