#pragma once

#include "absolute.h"
#include "diff.h"
#include "histogram.h"

#include <passport/infra/libs/cpp/json/writer.h>

namespace NPassport::NUnistat {
    class TBuilder {
    public:
        TBuilder(TString& out)
            : Writer_(out)
            , Stats_(Writer_)
        {
        }

        template <typename T>
        void Add(const T& signal) {
            AddRow(signal.GetName(), signal.GetValue());
        }

        template <typename T>
        void Add(const TSignalHistogram<T>& signal) {
            NJson::TArray arr(Stats_);
            arr.Add(signal.GetName());

            NJson::TArray values(arr);
            for (const auto& pair : signal.GetValues()) {
                NJson::TArray val(values);
                val.Add(pair.LeftBound);
                val.Add(pair.Value->GetValue());
            }
        }

        template <typename T>
        void AddRow(TStringBuf signalName, T value) {
            NJson::TArray row(Stats_);
            row.Add(signalName);
            row.Add(value);
        }

        template <typename T>
        void AddRow(const TName& name, T value) {
            NJson::TArray row(Stats_);
            row.Add(name.GetName());
            row.Add(value);
        }

    private:
        NJson::TWriter Writer_;
        NJson::TArray Stats_;
    };
}
