#include "consumers.h"

#include "builder.h"

namespace NPassport::NUnistat {
    TConsumersBase::TConsumersBase() {
        Storage_.reserve(10000);
    }

    void TConsumersBase::Add(const TString& name) {
        {
            std::shared_lock lock(Mutex_);
            auto it = Storage_.find(name);
            if (it != Storage_.end()) {
                ++it->second->Counter;
                return;
            }
        }

        std::unique_lock lock(Mutex_);
        auto [it, inserted] = Storage_.emplace(name, nullptr);
        if (inserted) {
            it->second = std::make_unique<TConsumer>(name);
        } else {
            ++it->second->Counter;
        }
    }

    void TSimpleConsumers::AddUnistat(TBuilder& builder) const {
        std::shared_lock lock(Mutex_);
        for (const auto& [name, consumer] : Storage_) {
            builder.Add(consumer->Counter);
        }
    }
}
