#pragma once

#include "diff.h"

#include <util/generic/string.h>

#include <shared_mutex>
#include <unordered_map>

namespace NPassport::NUnistat {
    class TBuilder;

    class TConsumersBase {
    public:
        TConsumersBase();

        void Add(const TString& name);

    protected:
        struct TConsumer {
            TConsumer(const TString& name)
                : Counter(name)
            {
                ++Counter;
            }

            TSignalDiff<> Counter;
        };

    protected:
        std::unordered_map<TString, std::unique_ptr<TConsumer>> Storage_;
        mutable std::shared_mutex Mutex_;
    };

    class TSimpleConsumers: public TConsumersBase {
    public:
        void AddUnistat(TBuilder& builder) const;
    };
}
