#pragma once

#include "name.h"

#include <passport/infra/libs/cpp/utils/atomic.h>

namespace NPassport::NUnistat::NSuffix {
    static const inline TString DMMM = "dmmm";
}

namespace NPassport::NUnistat::NBase {
    template <typename T>
    class TSignalDiff {
    public:
        using TIsDiffSignalTrait = std::true_type;
        using TCommonType = T;

        void operator+=(T value) {
            Value_.AddValue(value);
        }

        T operator++() {
            return ++Value_;
        }

        T GetValue() const {
            return Value_.GetValue();
        }

    protected:
        NUtils::TAtomicNum<T> Value_;
    };

    template <typename T>
    class TSignalBufferedDiff {
    public:
        using TIsDiffSignalTrait = std::true_type;
        using TCommonType = T;

        void operator+=(T value) {
            BufferedValue_ += value;
        }

        T operator++() {
            return ++BufferedValue_;
        }

        void Flush() {
            Value_.StoreValue(BufferedValue_);
        }

        T GetValue() const {
            return Value_.GetValue();
        }

    protected:
        NUtils::TAtomicNum<T> Value_;
        T BufferedValue_ = {};
    };
}

namespace NPassport::NUnistat {
    // Can be freely used from any thread
    template <typename T = ui64>
    class TSignalDiff: public TName, public NBase::TSignalDiff<T> {
    public:
        TSignalDiff(const TString& name, const TString& suffix = NSuffix::DMMM)
            : TName(name, suffix)
        {
        }
    };

    // Cheap version of TSignalDiff
    // All modifying operators and flush() must me called from the same thread
    template <typename T = ui64>
    class TSignalBufferedDiff: public TName, public NBase::TSignalBufferedDiff<T> {
    public:
        TSignalBufferedDiff(const TString& name, const TString& suffix = NSuffix::DMMM)
            : TName(name, suffix)
        {
        }
    };
}
