#include "handle.h"

#include "builder.h"

namespace NPassport::NUnistat {
    void THandles::Add(const TString& handleKey, const TString& signalName) {
        Data_.emplace(handleKey, TSerializable(signalName));
    }

    void THandles::AddUnistat(TBuilder& builder) const {
        for (const auto& [handleKey, serializable] : Data_) {
            builder.Add(*serializable.Counter);
        }
    }

    void THandles::Inc(const TStringBuf handleKey) {
        auto it = Data_.find(handleKey);
        if (it == Data_.end()) {
            return;
        }

        ++(*it->second.Counter);
    }
}
