#pragma once

#include "diff.h"

#include <util/generic/hash.h>

namespace NPassport::NUnistat {
    class TBuilder;

    class THandles {
    public:
        void Add(const TString& handleKey, const TString& signalName);

        void AddUnistat(TBuilder& builder) const;
        void Inc(const TStringBuf handleKey);

    private:
        struct TSerializable {
            TSerializable(const TString& signalName)
                : Counter(std::make_unique<NUnistat::TSignalDiff<>>(signalName))
            {
            }

            std::unique_ptr<NUnistat::TSignalDiff<>> Counter;
        };

        THashMap<TString, TSerializable> Data_;
    };
}
