#include "name_factory.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NUnistat {
    TNameFactory::TNameFactory(TStringBuf prefix, const TNameFactory::TTags& tags)
        : Prefix_(NUtils::CreateStr(MakeTagPrefix(tags), prefix))
    {
    }

    TString TNameFactory::Name(TStringBuf name, TStringBuf suffix) const {
        TString out;
        NUtils::Append(out, Prefix_, '.', FormatUnistatTag(name));
        suffix.SkipPrefix("_");
        if (suffix) {
            NUtils::Append(out, '_', suffix);
        }
        return out;
    }

    TString TNameFactory::MakeTagPrefix(const TNameFactory::TTags& tags) {
        TString out;
        for (const auto& [tag, value] : tags) {
            NUtils::Append(out, tag, '=', FormatUnistatTag(value), ';');
        }

        return out;
    }

    TString TNameFactory::FormatUnistatTag(TStringBuf tag) {
        TString tmp = TString(tag.Last(127));
        SubstGlobal(tmp, '/', '.');
        return tmp;
    }
}
