#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NPassport::NUnistat {
    class TNameFactory {
    public:
        using TTags = THashMap<TString, TString>;

        explicit TNameFactory(TStringBuf prefix, const TTags& tags = {});

        TString Name(TStringBuf name, TStringBuf suffix = "") const;

        static TString FormatUnistatTag(TStringBuf tag);

    private:
        static TString MakeTagPrefix(const TTags& tags);

    private:
        const TString Prefix_;
    };
}
