#include "time_stat.h"

#include "builder.h"

namespace NPassport::NUnistat {
    static const std::vector<ui64> DEFAULT_BOUNDS = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 17, 20, 25, 30, 35, 40, 45, 50, 60, 70, 80, 90, 100, 125, 150, 175, 200, 225, 250, 275, 300, 400, 500, 750, 1000, 2000, 3000};

    TTimeStat::TBounds TTimeStat::CreateDefaultBounds() {
        return CreateBoundsFromMilliseconds(DEFAULT_BOUNDS);
    }

    TTimeStat::TBounds TTimeStat::CreateBoundsFromMilliseconds(const std::vector<ui64>& bounds) {
        TBounds res;
        for (ui32 b : bounds) {
            res.push_back(TDuration::MilliSeconds(b));
        }
        return res;
    }

    TTimeStat::TBounds TTimeStat::CreateBoundsFromMaxValue(TDuration maxValue) {
        const size_t count = 50;
        NUnistat::TTimeStat::TBounds res;
        res.reserve(count);

        size_t step = maxValue.MicroSeconds() / count;
        for (size_t idx = 0; idx < count - 1; ++idx) {
            res.push_back(TDuration::MicroSeconds(idx * step));
        }
        res.push_back(maxValue);

        return res;
    }

    static TSignalHistogram<>::TBounds PrepareBounds(const TTimeStat::TBounds& bounds) {
        TSignalHistogram<>::TBounds res;
        res.reserve(bounds.size());
        for (TDuration b : bounds) {
            res.push_back(b.MilliSeconds());
        }
        return res;
    }

    TTimeStat::TTimeStat(const TString& msg, TBounds&& bounds)
        : Thresholds_(msg, PrepareBounds(bounds))
    {
    }

    void TTimeStat::Insert(TDuration item) {
        Thresholds_.AddValue(item.MilliSeconds());
    }

    void TTimeStat::AddUnistat(TBuilder& builder) const {
        builder.Add(Thresholds_);
    }
}
