#pragma once

#include "histogram.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NPassport::NUnistat {
    class TBuilder;

    class TTimeStat {
    public:
        using TBounds = std::vector<TDuration>;
        static TBounds CreateDefaultBounds();
        static TBounds CreateBoundsFromMilliseconds(const std::vector<ui64>& bounds);
        static TBounds CreateBoundsFromMaxValue(TDuration maxValue);

        TTimeStat(const TString& msg, TBounds&& bounds);
        virtual ~TTimeStat() = default;

        void Insert(TDuration item);

        void AddUnistat(TBuilder& builder) const;

    private:
        TSignalHistogram<> Thresholds_;
    };
}
