#include <passport/infra/libs/cpp/unistat/name_factory.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/string/split.h>

using namespace NPassport::NUnistat;

Y_UNIT_TEST_SUITE(Utils) {
    Y_UNIT_TEST(Generic) {
        TNameFactory factory(
            "autotest",
            {
                {
                    "filename",
                    "/etc/yandex/passport-logstoreagent/cache/ramilmsh-dev-bionic.passport.yandex.net/opt/nvme/storage/sezam-logs/blackbox-error.log/state",
                },
                {
                    "hostname",
                    "kvs-logstore-f1.passport.yandex.net",
                },
            });

        UNIT_ASSERT_VALUES_EQUAL(
            factory.Name("test1", "dmmm"),
            "filename=andex.passport-logstoreagent.cache.ramilmsh-dev-bionic.passport.yandex.net.opt.nvme.storage.sezam-logs.blackbox-error.log.state;hostname=kvs-logstore-f1.passport.yandex.net;autotest.test1_dmmm");

        UNIT_ASSERT_VALUES_EQUAL(
            factory.Name("test2", "_axxx"),
            "filename=andex.passport-logstoreagent.cache.ramilmsh-dev-bionic.passport.yandex.net.opt.nvme.storage.sezam-logs.blackbox-error.log.state;hostname=kvs-logstore-f1.passport.yandex.net;autotest.test2_axxx");
    }

    Y_UNIT_TEST(UnistatTagFormat) {
        UNIT_ASSERT_VALUES_EQUAL(TNameFactory::FormatUnistatTag(""), "");
        UNIT_ASSERT_VALUES_EQUAL(TNameFactory::FormatUnistatTag("/opt/sezam-logs/blackbox-error.log"), ".opt.sezam-logs.blackbox-error.log");
        UNIT_ASSERT_VALUES_EQUAL(TNameFactory::FormatUnistatTag("/very/long/path/name/to/the/file/opt/sezam-logs/blackbox-error.log/very/long/path/name/to/the/file/opt/sezam-logs/blackbox-error.log"), ".long.path.name.to.the.file.opt.sezam-logs.blackbox-error.log.very.long.path.name.to.the.file.opt.sezam-logs.blackbox-error.log");
    }
}
