#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NUnistat;

Y_UNIT_TEST_SUITE(PasspUtilsStat) {
    class TStatTest: public TTimeStat {
    public:
        using TTimeStat::TTimeStat;
    };

    Y_UNIT_TEST(unistat) {
        TStatTest stat("Test_wrapper", TTimeStat::CreateBoundsFromMilliseconds({3, 3, 10, 4, 5}));

        TString str;
        {
            TBuilder builder(str);
            stat.AddUnistat(builder);
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["Test_wrapper_dhhh",[[0,0],[3,0],[4,0],[5,0],[10,0]]]])", str);

        stat.Insert(TDuration::MicroSeconds(3500));

        {
            TBuilder builder(str);
            stat.AddUnistat(builder);
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["Test_wrapper_dhhh",[[0,0],[3,1],[4,0],[5,0],[10,0]]]])", str);

        stat.Insert(TDuration::MicroSeconds(2500));
        stat.Insert(TDuration::MilliSeconds(4));
        stat.Insert(TDuration::MilliSeconds(4));
        stat.Insert(TDuration::MicroSeconds(4000));
        stat.Insert(TDuration::MilliSeconds(7));
        stat.Insert(TDuration::MilliSeconds(40));
        stat.Insert(TDuration::Seconds(40));

        {
            TBuilder builder(str);
            stat.AddUnistat(builder);
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["Test_wrapper_dhhh",[[0,1],[3,1],[4,3],[5,1],[10,2]]]])", str);
    }
}
